/*
 * Decompiled with CFR 0.152.
 */
package com.porpit.ultimatestack.config;

import com.google.common.collect.Lists;
import com.porpit.ultimatestack.UltimateStack;
import com.porpit.ultimatestack.util.ItemHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ConfigLoader {
    private static Map<String, Configuration> modsConfigMap = new HashMap<String, Configuration>();
    public static final int MAX_STACK_SIZE = Short.MAX_VALUE;
    public static boolean isServerSuport = false;
    public static Map<String, Short> itemMaxStackSizeMap = new HashMap<String, Short>();
    public static Map<String, Short> oreOverrideLevel = new HashMap<String, Short>();
    public static Map<String, Short> oreMaxStackSizeMap = new HashMap<String, Short>();
    public static String modConfigurationDirectory;
    public static short defaultMaxStackSize;

    public ConfigLoader(FMLPreInitializationEvent event) {
        modConfigurationDirectory = event.getModConfigurationDirectory().getPath() + File.separator + "UltimateStack";
        ConfigLoader.loadModConfig("minecraft");
        ConfigLoader.load();
    }

    public static void loadModConfig(String key) {
        Configuration config = new Configuration(new File(modConfigurationDirectory + File.separator + "ItemMaxStackSize" + File.separator + key + ".cfg"));
        config.load();
        modsConfigMap.put(key, config);
    }

    public static Configuration getModConfig(String key) {
        if (!modsConfigMap.containsKey(key)) {
            ConfigLoader.loadModConfig(key);
        }
        return modsConfigMap.get(key);
    }

    public static void saveAllModConfig() {
        modsConfigMap.forEach((key, value) -> value.save());
    }

    public static void load() {
        UltimateStack.logger.info("Started loading config. ");
        ConfigLoader.loadMainConfig();
        UltimateStack.logger.info("Finished loading config. ");
    }

    public static void loadMainConfig() {
        Configuration mainConfig = new Configuration(new File(modConfigurationDirectory + File.separator + "Setting.cfg"));
        mainConfig.load();
        String common = "\u8bbe\u7f6e\u7269\u54c1(\u9664\u4e86\u539f\u59cb\u5806\u53e0\u4e3a1\u7684\u7269\u54c1)\u9ed8\u8ba4\u6700\u5927\u5806\u53e0\uff0c\u53ef\u88ab\u5176\u4ed6\u8bbe\u5b9a\u8986\u76d6   \u8303\u56f4:1-32767";
        int maxStackSize = mainConfig.get("general", "Default MaxStackSize", 1000, common).getInt();
        if (maxStackSize > Short.MAX_VALUE) {
            maxStackSize = Short.MAX_VALUE;
            mainConfig.get("general", "Default MaxStackSize", 1000, common).set(maxStackSize);
        } else if (maxStackSize <= 0) {
            maxStackSize = 1;
            mainConfig.get("general", "Default MaxStackSize", 1000, common).set(maxStackSize);
        }
        defaultMaxStackSize = (short)maxStackSize;
        mainConfig.save();
    }

    public static Map<String, List<ItemStack>> getCustomOreData() {
        HashMap<String, List<ItemStack>> oreItemsMap = new HashMap<String, List<ItemStack>>();
        File file = new File(modConfigurationDirectory + File.separator + "CustomOre.cfg");
        if (!file.exists()) {
            try {
                InputStreamReader reader = new InputStreamReader(UltimateStack.class.getClassLoader().getResourceAsStream("assets/ultimatestack/defaultconfig/CustomOre.cfg"));
                BufferedReader bf = new BufferedReader(reader);
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                String line = null;
                while ((line = bf.readLine()) != null) {
                    out.write(line + '\n');
                }
                out.flush();
                out.close();
                UltimateStack.logger.info("\u6210\u529f\u8bfb\u53d6\u9ed8\u8ba4\u6587\u4ef6 CustomOre.cfg");
            }
            catch (Exception e) {
                UltimateStack.logger.error("\u8bfb\u53d6\u9ed8\u8ba4\u6587\u4ef6 CustomOre.cfg \u5931\u8d25");
            }
        }
        Configuration customOreConfig = new Configuration(file);
        customOreConfig.load();
        Iterator iterator = customOreConfig.getCategory("CustomOre").getValues().values().iterator();
        customOreConfig.getCategory("CustomOre").setComment("\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u77ff\u5178   \u6ce8\u610f\u77ff\u5178\u540d\u79f0\u524d\u8981\u52a0S:");
        while (iterator.hasNext()) {
            Property p = (Property)iterator.next();
            if (p.getStringList().length <= 0) continue;
            ArrayList strings = Lists.newArrayList((Object[])p.getStringList());
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < p.getStringList().length; ++i) {
                Item item;
                String itemStackID = p.getStringList()[i];
                String[] nameAndMeta = itemStackID.split(":");
                String itemID = nameAndMeta[0];
                itemID = itemID + ":" + nameAndMeta[1];
                int metaData = 0;
                if (nameAndMeta.length >= 3) {
                    metaData = Integer.valueOf(nameAndMeta[2]);
                }
                if ((item = Item.func_111206_d((String)itemID)) == null) continue;
                items.add(new ItemStack(item, 1, metaData));
            }
            if (items.isEmpty()) continue;
            oreItemsMap.put(p.getName(), items);
        }
        customOreConfig.save();
        return oreItemsMap;
    }

    public static void loadItemData() {
        UltimateStack.logger.info("Started loading Item. ");
        itemMaxStackSizeMap.clear();
        oreOverrideLevel.clear();
        oreMaxStackSizeMap.clear();
        String allowRange = "  #\u8303\u56f4(range):1-32767  ";
        File oreFile = new File(modConfigurationDirectory + File.separator + "OreMaxStackSetting.cfg");
        if (!oreFile.exists()) {
            try {
                InputStreamReader reader = new InputStreamReader(UltimateStack.class.getClassLoader().getResourceAsStream("assets/ultimatestack/defaultconfig/OreMaxStackSetting.cfg"));
                BufferedReader bf = new BufferedReader(reader);
                BufferedWriter out = new BufferedWriter(new FileWriter(oreFile));
                String line = null;
                while ((line = bf.readLine()) != null) {
                    out.write(line + '\n');
                }
                out.flush();
                out.close();
                UltimateStack.logger.info("\u6210\u529f\u8bfb\u53d6\u9ed8\u8ba4\u6587\u4ef6 OreMaxStackSetting.cfg");
            }
            catch (Exception e) {
                UltimateStack.logger.error("\u8bfb\u53d6\u9ed8\u8ba4\u6587\u4ef6 OreMaxStackSetting.cfg \u5931\u8d25");
            }
        }
        Configuration oreConfig = new Configuration(oreFile);
        oreConfig.load();
        for (int i = 0; i < OreDictionary.getOreNames().length; ++i) {
            String oreName = OreDictionary.getOreNames()[i];
            oreConfig.setCategoryComment("OreLevelSetting", "\u8bbe\u7f6eOre\u7684\u7ea7\u522b\uff0c\u7ea7\u522b\u9ad8\u7684\u53ef\u4ee5\u8986\u76d6\u7ea7\u522b\u4f4e\u7684\u8bbe\u5b9a  \u8303\u56f41-10");
            Property p = oreConfig.get("OreLevelSetting", oreName, 1);
            int level = p.getInt();
            if (p.getInt() <= 0) {
                level = 1;
            }
            if (p.getInt() > 10) {
                level = 10;
            }
            oreOverrideLevel.put(oreName, (short)level);
            oreConfig.setCategoryComment("OreStackMaxSize", "\u8bbe\u7f6e\u77ff\u5178\u5305\u542b\u7684\u7269\u54c1\u7684\u6700\u5927\u5806\u53e0  " + allowRange + " \u8bbe\u7f6e\u4e3a0 \u5219\u4e0d\u8fdb\u884c\u4fee\u6539");
            p = oreConfig.get("OreStackMaxSize", oreName, 0);
            if (p.getInt() <= 0) continue;
            int maxStackSize = p.getInt();
            if (maxStackSize > Short.MAX_VALUE) {
                maxStackSize = Short.MAX_VALUE;
            } else if (maxStackSize <= 0) {
                maxStackSize = 1;
            }
            p.set(maxStackSize);
            oreMaxStackSizeMap.put(oreName, (short)maxStackSize);
        }
        for (Item item : ForgeRegistries.ITEMS) {
            if (item.getRegistryName() == null || item.equals(Items.field_190931_a)) continue;
            NonNullList lst = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, lst);
            lst.forEach(itemStack -> {
                String modId = item.getRegistryName().func_110624_b();
                String registryName = item.getRegistryName().toString();
                int metedata = itemStack.func_77960_j();
                String stackName = registryName + ":" + metedata;
                Configuration config = ConfigLoader.getModConfig(modId);
                String translateKey = itemStack.func_77977_a();
                String translateEnd = ".name";
                if (modId.equals("ic2") || modId.equals("advanced_solar_panels")) {
                    translateEnd = "";
                } else if (modId.equals("botania")) {
                    if (!translateKey.startsWith("tile.botania:")) {
                        translateKey = translateKey.replace("tile.", "tile.botania:");
                    }
                    if (!translateKey.startsWith("item.botania:")) {
                        translateKey = translateKey.replace("item.", "item.botania:");
                    }
                }
                String comment = new TextComponentTranslation(translateKey + translateEnd, new Object[0]).func_150261_e() + allowRange + "\n \u5305\u62ec\u6b64Item \u7684\u77ff\u5178:" + ItemHelper.getItemOreNames(itemStack);
                config.setCategoryComment("ItemStackMaxSize", "\u8bbe\u7f6e\u7269\u54c1\u5bf9\u5e94\u6700\u5927\u5806\u53e0  " + allowRange + " \u8bbe\u7f6e\u4e3a0\u5219\u7531\u77ff\u5178\u51b3\u5b9a");
                Property p = config.get("ItemStackMaxSize", stackName, 0, comment);
                int maxStackSize = itemStack.func_77976_d();
                if (maxStackSize != 1) {
                    maxStackSize = defaultMaxStackSize;
                }
                if (p.getInt() > 0) {
                    maxStackSize = p.getInt();
                    if (maxStackSize > Short.MAX_VALUE) {
                        maxStackSize = Short.MAX_VALUE;
                    } else if (maxStackSize <= 0) {
                        maxStackSize = 1;
                    }
                    p.set(maxStackSize);
                } else {
                    String oreName = ConfigLoader.getHighLevelOreMaxSetting(ItemHelper.getItemOreNames(itemStack));
                    if (oreName != null) {
                        maxStackSize = oreMaxStackSizeMap.get(oreName).shortValue();
                        p.setComment(comment + "\n\u76ee\u524d\u5df2\u88ab\u77ff\u5178:" + oreName + "\u8bbe\u7f6e\u9ed8\u8ba4\u503c\u4e3a:" + maxStackSize);
                    }
                }
                itemMaxStackSizeMap.put(stackName, (short)maxStackSize);
            });
        }
        oreConfig.save();
        ConfigLoader.saveAllModConfig();
        UltimateStack.logger.info("Finished loading Item. ");
    }

    public static String getHighLevelOreMaxSetting(List<String> oreNames) {
        if (!oreNames.isEmpty()) {
            oreNames.sort((it, it2) -> Integer.compare(oreOverrideLevel.get(it).shortValue(), oreOverrideLevel.get(it).shortValue()));
            for (String oreName : oreNames) {
                if (!oreMaxStackSizeMap.containsKey(oreName)) continue;
                return oreName;
            }
        }
        return null;
    }

    public static void loadItemDataFormServer(Map<String, Short> itemMaxStackSizeMapFrom) {
        itemMaxStackSizeMap = itemMaxStackSizeMapFrom;
    }

    public static int getMaxStackSizeSetting(Object object) {
        if (object instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            Short maxStackSize = itemMaxStackSizeMap.get(itemStack.func_77973_b().getRegistryName() + ":" + itemStack.func_77960_j());
            return maxStackSize == null ? itemStack.func_77973_b().getItemStackLimit(itemStack) : maxStackSize.shortValue();
        }
        return 1;
    }

    static {
        defaultMaxStackSize = (short)64;
    }
}

